<?php

function http_response_code_text($code = NULL)
{
    $text = 'OK';
    if ($code !== NULL) {

        switch ($code) {
            case 100:
                $text = 'Continue';
                break;
            case 101:
                $text = 'Switching Protocols';
                break;
            case 200:
                $text = 'OK';
                break;
            case 201:
                $text = 'Created';
                break;
            case 202:
                $text = 'Accepted';
                break;
            case 203:
                $text = 'Non-Authoritative Information';
                break;
            case 204:
                $text = 'No Content';
                break;
            case 205:
                $text = 'Reset Content';
                break;
            case 206:
                $text = 'Partial Content';
                break;
            case 300:
                $text = 'Multiple Choices';
                break;
            case 301:
                $text = 'Moved Permanently';
                break;
            case 302:
                $text = 'Moved Temporarily';
                break;
            case 303:
                $text = 'See Other';
                break;
            case 304:
                $text = 'Not Modified';
                break;
            case 305:
                $text = 'Use Proxy';
                break;
            case 400:
                $text = 'Bad Request';
                break;
            case 401:
                $text = 'Unauthorized';
                break;
            case 402:
                $text = 'Payment Required';
                break;
            case 403:
                $text = 'Forbidden';
                break;
            case 404:
                $text = 'Not Found';
                break;
            case 405:
                $text = 'Method Not Allowed';
                break;
            case 406:
                $text = 'Not Acceptable';
                break;
            case 407:
                $text = 'Proxy Authentication Required';
                break;
            case 408:
                $text = 'Request Time-out';
                break;
            case 409:
                $text = 'Conflict';
                break;
            case 410:
                $text = 'Gone';
                break;
            case 411:
                $text = 'Length Required';
                break;
            case 412:
                $text = 'Precondition Failed';
                break;
            case 413:
                $text = 'Request Entity Too Large';
                break;
            case 414:
                $text = 'Request-URI Too Large';
                break;
            case 415:
                $text = 'Unsupported Media Type';
                break;
            case 500:
                $text = 'Internal Server Error';
                break;
            case 501:
                $text = 'Not Implemented';
                break;
            case 502:
                $text = 'Bad Gateway';
                break;
            case 503:
                $text = 'Service Unavailable';
                break;
            case 504:
                $text = 'Gateway Time-out';
                break;
            case 505:
                $text = 'HTTP Version not supported';
                break;
            default:
                $text = ('Unknown http status code "' . htmlentities($code) . '"');
                break;
        }

    } else {

        $text = ('Unknown http status code "' . htmlentities($code) . '"');

    }
    return $text;
}

function sendApiGetRequest(){

    $baseUrl = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $parse_url = parse_url($baseUrl);
    $slug = trim($parse_url['path'], '/');
    $slug = str_replace('apiv1/', '', $slug);
    $host = trim($_SERVER['HTTP_HOST']);

    $url =  'https://apwaps.ftt11.com/'.$slug.'?'. $_SERVER['QUERY_STRING'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

    $result = curl_exec($ch);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    /* if (curl_errno($ch)) {
         $error_msg = curl_error($ch);
         curl_close($ch);
         print_r($error_msg);die(' err');
     }*/

    curl_close($ch);

    $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
    $text = http_response_code_text($httpCode);
    header($protocol . ' ' . $httpCode . ' ' . $text);

    header('Content-type: '. $contentType);
    echo $result;
    exit();
}

function sendApiPostRequest() {
    $baseUrl = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    $parse_url = parse_url($baseUrl);
    $slug = trim($parse_url['path'], '/');
    $slug = str_replace('apiv1/', '', $slug);
    $host = trim($_SERVER['HTTP_HOST']);
    $requestContentType = $_SERVER["CONTENT_TYPE"];
    $url =  'https://apwaps.ftt11.com/'.$slug.'?'. $_SERVER['QUERY_STRING'];

    $refererUrl = $_SERVER['HTTP_REFERER'] ?? '';
    $http_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';


    $data = json_decode(file_get_contents('php://input'), true); // json post data


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS,$data);
    # curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: multipart/form-data'));
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_USERAGENT, $http_user_agent);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

    $result = curl_exec($ch);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
        curl_close($ch);
        return ($error_msg);
    }

    curl_close($ch);
    $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
    $text = http_response_code_text($httpCode);
    header($protocol . ' ' . $httpCode . ' ' . $text);

    header('Content-type: '. $contentType);
    echo $result;
    exit();

}

$method = $_SERVER['REQUEST_METHOD'];
if ($method === 'GET'){
    sendApiGetRequest();
} elseif ($method === 'POST'){
    sendApiPostRequest();
} else {
    echo 'HTTP REQUEST ERROR';
    exit();
}

