<?php

function http_response_code_text($code = NULL)
{
    $text = 'OK';
    if ($code !== NULL) {

        switch ($code) {
            case 100:
                $text = 'Continue';
                break;
            case 101:
                $text = 'Switching Protocols';
                break;
            case 200:
                $text = 'OK';
                break;
            case 201:
                $text = 'Created';
                break;
            case 202:
                $text = 'Accepted';
                break;
            case 203:
                $text = 'Non-Authoritative Information';
                break;
            case 204:
                $text = 'No Content';
                break;
            case 205:
                $text = 'Reset Content';
                break;
            case 206:
                $text = 'Partial Content';
                break;
            case 300:
                $text = 'Multiple Choices';
                break;
            case 301:
                $text = 'Moved Permanently';
                break;
            case 302:
                $text = 'Moved Temporarily';
                break;
            case 303:
                $text = 'See Other';
                break;
            case 304:
                $text = 'Not Modified';
                break;
            case 305:
                $text = 'Use Proxy';
                break;
            case 400:
                $text = 'Bad Request';
                break;
            case 401:
                $text = 'Unauthorized';
                break;
            case 402:
                $text = 'Payment Required';
                break;
            case 403:
                $text = 'Forbidden';
                break;
            case 404:
                $text = 'Not Found';
                break;
            case 405:
                $text = 'Method Not Allowed';
                break;
            case 406:
                $text = 'Not Acceptable';
                break;
            case 407:
                $text = 'Proxy Authentication Required';
                break;
            case 408:
                $text = 'Request Time-out';
                break;
            case 409:
                $text = 'Conflict';
                break;
            case 410:
                $text = 'Gone';
                break;
            case 411:
                $text = 'Length Required';
                break;
            case 412:
                $text = 'Precondition Failed';
                break;
            case 413:
                $text = 'Request Entity Too Large';
                break;
            case 414:
                $text = 'Request-URI Too Large';
                break;
            case 415:
                $text = 'Unsupported Media Type';
                break;
            case 500:
                $text = 'Internal Server Error';
                break;
            case 501:
                $text = 'Not Implemented';
                break;
            case 502:
                $text = 'Bad Gateway';
                break;
            case 503:
                $text = 'Service Unavailable';
                break;
            case 504:
                $text = 'Gateway Time-out';
                break;
            case 505:
                $text = 'HTTP Version not supported';
                break;
            default:
                $text = ('Unknown http status code "' . htmlentities($code) . '"');
                break;
        }

    } else {

        $text = ('Unknown http status code "' . htmlentities($code) . '"');

    }
    return $text;
}

function sendGetRequest($url) {

    $refererUrl = $_SERVER['HTTP_REFERER'] ?? '';
    $http_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $http_user_agent_2 = $_SERVER['HTTP_SEC_CH_UA'] ?? ''; // to detect Lighthouse

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_REFERER, $refererUrl);
    curl_setopt($ch, CURLOPT_USERAGENT, $http_user_agent. '; ' . $http_user_agent_2);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    $result = curl_exec($ch);
   // $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    /* if (curl_errno($ch)) {
         $error_msg = curl_error($ch);
         curl_close($ch);
         print_r($error_msg);die(' err');
     }*/

    curl_close($ch);
    $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
    $text = http_response_code_text($httpCode);


    header($protocol . ' ' . $httpCode . ' ' . $text);

    return $result;

}


$domain = 'https:/apwaps.ftt11.com/';


/**
 * Seo Request
 */
$http_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$refererUrl = $_SERVER['HTTP_REFERER'] ?? '';
$baseUrl = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$parse_url = parse_url($baseUrl);
$slug = ltrim($parse_url['path'], '/');
$host = trim($_SERVER['HTTP_HOST']);

$query = explode('&', $_SERVER['QUERY_STRING']);
$query[]='host='.$host;
$query[]='slug='.$slug;
$query[]='ref='.$refererUrl;

if (!$query[0]){
    unset($query[0]);
}
$queryStr = implode("&", $query);
$api_url =  $domain .'seo?'. $queryStr;

$result = sendGetRequest($api_url);

$data = json_decode($result);
$cssFile = $data->app_data->cssFile;
$jsFiles = $data->app_data->jsFiles;
unset($data->app_data->cssFile);
unset($data->app_data->jsFiles);
/**
 * if bot print html page and stop loading the page
 */
if (isset($data->isPage)){
    echo $data->page;
    die();
}
/**
 * else echo json seo data and complete loading the page
 */
$app_data = json_encode($data->app_data);

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <base href="/"/>
    <?php

    echo $data->seo;

    ?>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <!--[if IE]>
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <script>
        window.history.replaceState = function (){ console.log('Empty stub for history.replaceState()') };
    </script>
    <![endif]-->

    <link rel="icon" type="image/png" href="<?=$data->favicon;?>"/>
    <link rel="apple-touch-icon" sizes="180x180" href="<?=$data->favicon;?>"/>

    <meta name="theme-color" content="#1976d2">
</head>
<body class="common-home res layout-home7">

<noscript>
    <p>
        This page requires JavaScript to work properly. Please enable JavaScript in your browser.
    </p>
</noscript>

<div id="wrapper" class="wrapper-full banners-effect-7">
    <?php
    if (isset($error_msg)) {
        //  print_r($error_msg) ;
    }
    ?>
    <app-root></app-root>

</div>

<script type="text/javascript">

    var giftofspeed2 = document.createElement('link');
    giftofspeed2.rel = 'stylesheet';
    giftofspeed2.href = '<?= $cssFile?>';
    giftofspeed2.type = 'text/css';
    var godefer2 = document.getElementsByTagName('link')[0];
    godefer2.parentNode.insertBefore(giftofspeed2, godefer2);

    FontAwesomeConfig = {searchPseudoElements: true};
    window.lazySizesConfig = window.lazySizesConfig || {};
    window['app_data'] = JSON.parse(JSON.stringify(<?=$app_data ;?>)) ;
    lazySizesConfig.srcAttr = 'data-lazy';



        window.__lo_site_id = 122504;

        (function() {
        var wa = document.createElement('script'); wa.type = 'text/javascript'; wa.async = true;
        wa.src = 'https://d10lpsik1i8c69.cloudfront.net/w.js';
        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(wa, s);
    })();
</script>

<script src="./assets/js/jquery.min.js" type="text/javascript" defer=""></script>
<script src="./assets/js/lazysizes.min.js" type="text/javascript" defer=""></script>
<?php
foreach ($jsFiles as $js) {
    echo '<script src="'.$js.'" defer></script>';
}
?>
</body>
</html>
